@echo off
REM Unit Test Runner for Windows
REM Runs all unit tests for the Redact PII Detection API

echo.
echo ================================================
echo   Redact API - Unit Test Suite
echo ================================================
echo.

REM Check if PHP is available
php --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: PHP is not installed or not in PATH
    echo Please install PHP and add it to your PATH
    pause
    exit /b 1
)

REM Run the test runner
php "%~dp0TestRunner.php"

REM Capture exit code
set EXITCODE=%errorlevel%

echo.
if %EXITCODE% equ 0 (
    echo Tests completed successfully!
) else (
    echo Tests failed with exit code %EXITCODE%
)

pause
exit /b %EXITCODE%
