# Unit Tests for Redact PII Detection API

Comprehensive unit tests for all core classes in the PII Detection API.

## 📋 Test Coverage

### Classes Tested
1. **ComprehendService** - AWS Comprehend PII detection
2. **FileHandler** - File validation and conversion
3. **TextractService** - AWS Textract document analysis
4. **ThreadManager** - Thread/session management
5. **RegistryManager** - Registry and cache management
6. **PIIDetectionService** - Main orchestrator service

## 🚀 Running Tests

### Windows (PowerShell)
```powershell
php Unit/TestRunner.php
```

### Windows (Batch)
```cmd
Unit\run_tests.bat
```

### Individual Test Files
```powershell
php Unit/ComprehendServiceTest.php
php Unit/FileHandlerTest.php
php Unit/TextractServiceTest.php
php Unit/ThreadManagerTest.php
php Unit/RegistryManagerTest.php
php Unit/PIIDetectionServiceTest.php
```

## 📊 Test Structure

Each test file follows this structure:
- **Setup**: Initialize test environment and dependencies
- **Test Methods**: Individual test cases for each public method
- **Assertions**: Verify expected behavior
- **Cleanup**: Clean up test data and resources

## ✅ Test Types

### Unit Tests
- Test individual methods in isolation
- Mock external dependencies (AWS services, file system)
- Validate input/output behavior
- Check error handling

### Integration Tests
- Test interactions between classes
- Validate end-to-end workflows
- Verify data persistence and caching

## 📝 Test Data

Test files are located in `Unit/test_data/`:
- Sample PDF files
- Sample images (JPEG, PNG)
- Mock API responses
- Test configuration files

## 🔍 Requirements

- PHP 7.4+
- Imagick extension (for PDF conversion tests)
- Write permissions to `Unit/test_data/` directory
- AWS credentials in `src/config/config.php` (for integration tests)

## 📈 Expected Results

All tests should pass with output similar to:
```
===========================================
  UNIT TEST RESULTS
===========================================

ComprehendServiceTest:        ✓ PASSED (6/6 tests)
FileHandlerTest:              ✓ PASSED (8/8 tests)
TextractServiceTest:          ✓ PASSED (5/5 tests)
ThreadManagerTest:            ✓ PASSED (12/12 tests)
RegistryManagerTest:          ✓ PASSED (9/9 tests)
PIIDetectionServiceTest:      ✓ PASSED (7/7 tests)

===========================================
TOTAL: 47/47 tests passed ✓
===========================================
```

## 🐛 Troubleshooting

### Imagick Extension Missing
If Imagick is not installed, PDF conversion tests will be skipped.
Install Imagick for full test coverage.

### Permission Errors
Ensure write permissions to `Unit/test_data/` and `data/` directories.

### AWS Credentials
For integration tests that call AWS APIs, ensure credentials are configured in `src/config/config.php`.

## 📚 Documentation

For more information, see:
- [API Documentation](../api/README.md)
- [Class Documentation](../src/classes/USAGE.md)
- [Thread System](../src/classes/README_THREADS.md)
